# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT_cli_rc;
#"@(#)20   1.2   src/rsct/cli/pm/CT_cli_rc.pm.perl, ctcli, rsct_rpyxh, rpyxht1f3 2/2/01 21:15:35"
######################################################################
#                                                                    #
# Package: CT_cli_rc.pm                                              #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the PERL             #
#   Cluster Technology CLi utilities. Each return code can be        #
#   referenced separately, or as a whole using the 'return_codes'    #
#   EXPORT_TAG.                                                      #
#                                                                    #
# Examples:                                                          #
#   use CT_cli_rc qw(CT_CLI_BAD_OPERAND CT_CLI_BAD_FLAG)             #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use CT_cli_rc qw(:return_codes)                                  #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000900 HGJ xxxxx: Initial delivery.                              #
#                                                                    #
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    CT_CLI_SUCCESS
                    CT_CLI_EXT_ERROR
                    CT_CLI_ERROR
                    CT_CLI_BAD_FLAG
                    CT_CLI_BAD_OPERAND
                    CT_CLI_USER_ERROR
);

#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(CT_CLI_BAD_FLAG     CT_CLI_EXT_ERROR
                    CT_CLI_BAD_OPERAND  CT_CLI_SUCCESS
                    CT_CLI_USER_ERROR   CT_CLI_ERROR
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions (constants)                                #
#--------------------------------------------------------------------#

use constant CT_CLI_SUCCESS         => 0;
use constant CT_CLI_EXT_ERROR       => 1;
use constant CT_CLI_ERROR           => 2;       
use constant CT_CLI_BAD_FLAG        => 3;
use constant CT_CLI_BAD_OPERAND     => 4;
use constant CT_CLI_USER_ERROR      => 5;
